(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2707,         82]*)
(*NotebookOutlinePosition[      3350,        104]*)
(*  CellTagsIndexPosition[      3306,        100]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(Table[aplog[n, x_] = n \((\@x\%n - 1)\), {n, 50}];\)\)], "Input"],

Cell[BoxData[
    \(graf[n_, a_, b_] := 
      Plot[{Log[x\ ], aplog[n, x]}, {x, a, b}, 
        PlotRange \[Rule] {N[Log[a]] - 2, N[Log[b] + 3]}, 
        PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}]\)], "Input"],

Cell[BoxData[
    \(Table[graf[n, 0.15, 20], {n, 1, 20}]\)], "Input"],

Cell[BoxData[
    \(grafdif[n_, a_, b_] := 
      Plot[\(-Log[x]\) + aplog[n, x], {x, a, b}, 
        PlotRange \[Rule] {0, 1}]\)], "Input"],

Cell[BoxData[
    \(Table[grafdif[n, 0.15, 30], {n, 30}]\)], "Input"],

Cell[BoxData[
    \(\(Table[apexp[n, x_] = \((1 + x/n)\)^n, {n, 50}];\)\)], "Input"],

Cell[BoxData[
    \(grafexp[n_, a_, b_] := 
      Plot[{Exp[x\ ], apexp[n, x]}, {x, a, b}, 
        PlotRange \[Rule] {N[Exp[a]] - 2, N[Exp[b] - 3]}, 
        PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 0, 1]}]\)], "Input"],

Cell[BoxData[
    \(Table[grafexp[n, \(-2\), 2], {n, 1, 20}]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{872, 649},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 87, 1, 33, "Input"],
Cell[1795, 53, 226, 4, 50, "Input"],
Cell[2024, 59, 69, 1, 30, "Input"],
Cell[2096, 62, 140, 3, 30, "Input"],
Cell[2239, 67, 69, 1, 30, "Input"],
Cell[2311, 70, 84, 1, 30, "Input"],
Cell[2398, 73, 229, 4, 50, "Input"],
Cell[2630, 79, 73, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

